//
//  StarSlider.m
//  HelloWorld
//
//  Created by Erica Sadun on 2/25/10.
//  Copyright 2010 Up To No Good, Inc. All rights reserved.
//

#import "StarSlider.h"

#define WIDTH 24.0f
#define OFF_ART	[UIImage imageNamed:@"Star-White-Half.png"]
#define ON_ART	[UIImage imageNamed:@"Star-White.png"]

@implementation StarSlider
@synthesize value;

- (id) initWithFrame: (CGRect) aFrame
{
	if (self = [super initWithFrame:aFrame])
	{
		float minimumWidth = WIDTH * 8.0f; // Umieszczenie pięciu gwiazd wraz z odstępami pomiędzy nimi i krawędziami kontrolki.
		float minimumHeight = 34.0f;
		
		// Kontrolka używa ramki o minimalnej wielkości 260×34 piksele.
		self.frame = CGRectMake(0.0f, 0.0f, MAX(minimumWidth, aFrame.size.width), MAX(minimumHeight, aFrame.size.height));
		
		// Dodanie gwiazdek — początkowo zakładamy stałą szerokość.
		float offsetCenter = WIDTH;
		for (int i = 1; i <= 5; i++)
		{
			UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0.0f, 0.0f, WIDTH, WIDTH)];
			imageView.image = OFF_ART;
			imageView.center = CGPointMake(offsetCenter, self.frame.size.height / 2.0f);
			offsetCenter += WIDTH * 1.5f;
			[self addSubview:imageView];
		}
	}
	
	self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.25f];

	return self;
}

- (id) init
{
	return [self initWithFrame:CGRectZero];
}

+ (id) control
{
	return [[self alloc] init];
}

- (void) updateValueAtPoint: (CGPoint) p
{
	int newValue = 0;
	UIImageView *changedView = nil;
	
	for (UIImageView *eachItem in [self subviews])
		if (p.x < eachItem.frame.origin.x)
		{
			eachItem.image = OFF_ART;
		}
		else 
		{
			changedView = eachItem;
			eachItem.image = ON_ART;
			newValue++;
		}
	
	if (self.value != newValue)
	{
		self.value = newValue;
		[self sendActionsForControlEvents:UIControlEventValueChanged];
		
		// Animacja nowego widoku.
		[UIView animateWithDuration:0.15f
						 animations:^{changedView.transform = CGAffineTransformMakeScale(1.5f, 1.5f);}
						 completion:^(BOOL done){[UIView animateWithDuration:0.1f animations:^{changedView.transform = CGAffineTransformIdentity;}];}];
	}	
}

- (BOOL)beginTrackingWithTouch:(UITouch *)touch withEvent:(UIEvent *)event
{
	// Utworzenie zdarzenia dotknięcia.
	CGPoint touchPoint = [touch locationInView:self];
	[self sendActionsForControlEvents:UIControlEventTouchDown];
	
	// Obliczenie wartości.
	[self updateValueAtPoint:touchPoint];
	return YES;
}
	 
- (BOOL)continueTrackingWithTouch:(UITouch *)touch withEvent:(UIEvent *)event
{
	// Sprawdzenie, czy miejsce dotknięcia znajduje się w kontrolce, czy poza nią.
	CGPoint touchPoint = [touch locationInView:self];
	if (CGRectContainsPoint(self.frame, touchPoint))
        [self sendActionsForControlEvents:UIControlEventTouchDragInside];
    else 
        [self sendActionsForControlEvents:UIControlEventTouchDragOutside];

	// Obliczenie wartości.
	[self updateValueAtPoint:[touch locationInView:self]];
	return YES;
}

- (void) endTrackingWithTouch: (UITouch *)touch withEvent: (UIEvent *)event
{
    // Sprawdzenie, czy miejsce dotknięcia znajduje się w kontrolce, czy poza nią.
    CGPoint touchPoint = [touch locationInView:self];
    if (CGRectContainsPoint(self.bounds, touchPoint))
        [self sendActionsForControlEvents:UIControlEventTouchUpInside];
    else 
        [self sendActionsForControlEvents:UIControlEventTouchUpOutside];
}

	 
- (void)cancelTrackingWithEvent: (UIEvent *) event
{
	[self sendActionsForControlEvents:UIControlEventTouchCancel];
}
@end
